# Dropzone Action Info
# Name: Move Files
# Description: Allows you to move dropped files to a specified folder. Hold down option while dragging to copy.
# Handles: Files
# Creator: Aptonic
# URL: https://aptonic.com
# OptionsNIB: ChooseFolder
# UseSelectedItemNameAndIcon: Yes
# SkipConfig: No
# RunsSandboxed: Yes
# Version: 1.0
# MinDropzoneVersion: 4.0

def dragged
  $dz.determinate(true)
  move = true
  
  if ENV['OPERATION'] == "NSDragOperationCopy"
    operation = "Copying"
    move = false
  else
    operation = "Moving"
  end
  
  $dz.begin("#{operation} files...")

  Rsync.do_copy($items, ENV['EXTRA_PATH'], move)
  
  finish_op = (move ? "Move" : "Copy")
  last_component = ENV['EXTRA_PATH'].split('/').last.gsub(/^(.{30,}?).*$/m,'\1...')
  
  $dz.finish("Click here to open the '#{last_component}' folder")
  $dz.url(false)
end

def clicked
  escaped_path = ENV['EXTRA_PATH'].gsub(/["`$\\]/){ |s| '\\' + s }
  system("open \"#{escaped_path}\"")
end
